/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.utils.Array;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.mapgen.model.FloorType;
import technology.rocketjump.undermount.mapgen.model.RockGroup;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class CellularAutomata {
    private final int deathLimit = 4;
    private final int birthLimit = 4;

    public void growRiver(GameMap map) {
        List<GridPoint2> riverTiles = map.getRiverTiles();
        if (riverTiles == null) {
            return;
        }
        HashSet<GameMapTile> riverNeighbourTiles = new HashSet<GameMapTile>();
        for (GridPoint2 riverTile : riverTiles) {
            for (GameMapTile neighbour : map.getOrthogonalNeighbours(riverTile)) {
                if (neighbour.hasRiver() || !neighbour.getTileType().equals((Object)TileType.OUTSIDE)) continue;
                riverNeighbourTiles.add(neighbour);
            }
        }
        for (GameMapTile riverNeighbourTile : riverNeighbourTiles) {
            long numOrthogonalRiverTiles = 0L;
            for (GameMapTile neighbourTile : map.getOrthogonalNeighbours(riverNeighbourTile.getPosition())) {
                if (!neighbourTile.hasRiver()) continue;
                ++numOrthogonalRiverTiles;
            }
            if (numOrthogonalRiverTiles >= 2L) {
                riverNeighbourTile.setRiver(true);
                riverTiles.add(riverNeighbourTile.getPosition());
                continue;
            }
            if (numOrthogonalRiverTiles != 1L) continue;
            long numDiagonalRiverTiles = 0L;
            for (GameMapTile neighbour : map.getDiagonalNeighbours(riverNeighbourTile.getPosition())) {
                if (!neighbour.hasRiver()) continue;
                ++numDiagonalRiverTiles;
            }
            if (numDiagonalRiverTiles < 2L) continue;
            riverNeighbourTile.setRiver(true);
            riverTiles.add(riverNeighbourTile.getPosition());
        }
    }

    public GameMap smoothCaves(GameMap input) {
        GameMap output = input.clone();
        for (int x = 0; x < input.getWidth(); ++x) {
            for (int y = 0; y < input.getHeight(); ++y) {
                GameMapTile tile = input.get(x, y);
                if (tile.getFloorType() == FloorType.Outdoor) continue;
                int wallNeighbours = 8 - input.getNumWallNeighbours(x, y);
                if (tile.getFloorType() != FloorType.None) {
                    if (wallNeighbours < 4) {
                        output.get(x, y).setAsMountain();
                        continue;
                    }
                    output.get(x, y).setAsCave();
                    continue;
                }
                if (wallNeighbours > 4) {
                    output.get(x, y).setAsCave();
                    continue;
                }
                output.get(x, y).setAsMountain();
            }
        }
        return output;
    }

    public GameMap smoothWalls(GameMap input) {
        GameMap output = input.clone();
        for (int x = 0; x < input.getWidth(); ++x) {
            for (int y = 0; y < input.getHeight(); ++y) {
                int wallNeighbours = input.getNumWallNeighbours(x, y);
                GameMapTile tile = input.get(x, y);
                if (tile.getFloorType() == FloorType.None) {
                    if (wallNeighbours < 4) {
                        output.get(x, y).setAsOutside();
                        continue;
                    }
                    output.get(x, y).setAsMountain();
                    continue;
                }
                if (wallNeighbours > 4) {
                    output.get(x, y).setAsMountain();
                    continue;
                }
                output.get(x, y).setAsOutside();
            }
        }
        this.fixCorner(output, 0, 0, 1, 1);
        this.fixCorner(output, 0, output.getHeight() - 1, 1, -1);
        this.fixCorner(output, output.getWidth() - 1, 0, -1, 1);
        this.fixCorner(output, output.getWidth() - 1, output.getHeight() - 1, -1, -1);
        return output;
    }

    /*
     * WARNING - void declaration
     */
    public GameMap smoothRockTypes(GameMap input) {
        GameMap output = input.clone();
        for (int x = 0; x < input.getWidth(); ++x) {
            for (int y = 0; y < input.getHeight(); ++y) {
                void var9_10;
                GameMapTile currentTile = input.get(x, y);
                if (currentTile.getRockGroup().equals((Object)RockGroup.None)) continue;
                Array<GameMapTile> neighbours = input.getAllNeighbourTiles(x, y);
                neighbours.add(currentTile);
                EnumMap<RockGroup, Integer> typeCounts = new EnumMap<RockGroup, Integer>(RockGroup.class);
                for (GameMapTile gameMapTile : neighbours) {
                    if (gameMapTile.getRockGroup().equals((Object)RockGroup.None)) continue;
                    Integer currentCount = (Integer)typeCounts.get((Object)gameMapTile.getRockGroup());
                    if (currentCount == null) {
                        currentCount = 0;
                    }
                    Integer n = currentCount;
                    Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
                    typeCounts.put(gameMapTile.getRockGroup(), currentCount);
                }
                int maxCount = 0;
                for (Integer count : typeCounts.values()) {
                    if (count <= maxCount) continue;
                    maxCount = count;
                }
                Object var9_14 = null;
                for (Map.Entry entry : typeCounts.entrySet()) {
                    if ((Integer)entry.getValue() != maxCount) continue;
                    RockGroup rockGroup = (RockGroup)((Object)entry.getKey());
                    break;
                }
                if (var9_10 == null || var9_10.equals((Object)currentTile.getRockGroup())) continue;
                output.get(x, y).setRockGroup((RockGroup)var9_10);
            }
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    public GameMap smoothOutdoorSubregions(GameMap input) {
        GameMap output = input.clone();
        for (int x = 0; x < input.getWidth(); ++x) {
            for (int y = 0; y < input.getHeight(); ++y) {
                void var9_10;
                GameMapTile currentTile = input.get(x, y);
                if (!currentTile.getTileType().equals((Object)TileType.OUTSIDE)) continue;
                Array<GameMapTile> neighbours = input.getAllNeighbourTiles(x, y);
                EnumMap<TileSubType, Integer> typeCounts = new EnumMap<TileSubType, Integer>(TileSubType.class);
                for (GameMapTile gameMapTile : neighbours) {
                    if (!gameMapTile.getTileType().equals((Object)TileType.OUTSIDE)) continue;
                    Integer currentCount = (Integer)typeCounts.get((Object)gameMapTile.getTileSubType());
                    if (currentCount == null) {
                        currentCount = 0;
                    }
                    Integer n = currentCount;
                    Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
                    typeCounts.put(gameMapTile.getTileSubType(), currentCount);
                }
                int maxCount = 0;
                for (Integer count : typeCounts.values()) {
                    if (count <= maxCount) continue;
                    maxCount = count;
                }
                Object var9_14 = null;
                for (Map.Entry subRegionTypeIntegerEntry : typeCounts.entrySet()) {
                    if ((Integer)subRegionTypeIntegerEntry.getValue() != maxCount) continue;
                    TileSubType tileSubType = (TileSubType)((Object)subRegionTypeIntegerEntry.getKey());
                    break;
                }
                if (var9_10 == null || var9_10.equals((Object)currentTile.getTileSubType())) continue;
                output.get(x, y).setTileSubType((TileSubType)var9_10);
            }
        }
        return output;
    }

    private void fixCorner(GameMap output, int targetX, int targetY, int offsetX, int offsetY) {
        GameMapTile cornerTile = output.get(targetX, targetY);
        if (cornerTile.getTileType().equals((Object)TileType.OUTSIDE)) {
            if (output.get(targetX, targetY + offsetY).getTileType().equals((Object)TileType.MOUNTAIN) && output.get(targetX + offsetX, targetY).getTileType().equals((Object)TileType.MOUNTAIN)) {
                cornerTile.setAsMountain();
            }
        } else if (output.get(targetX, targetY + offsetY).getTileType().equals((Object)TileType.OUTSIDE) && output.get(targetX + offsetX, targetY).getTileType().equals((Object)TileType.OUTSIDE)) {
            cornerTile.setAsOutside();
        }
    }
}

